/***************************************************************************
 *
 * Copyright 2012 BMW Car IT GmbH
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef _CONFIGURATOR_
#define _CONFIGURATOR_

#include "IConfigurator.h"
#include "PluginBase.h"
#include "system_types.h"
#include <string>

class ICommandExecutor;
class Configuration;

/**
 * Configurator plugin will be loaded as first plug in LayerManager
 * and can be used for setting the configuration at runtime
 */
class AIVIConfigurator : public IConfigurator, public IPlugin
{
public:

    AIVIConfigurator(ICommandExecutor& executor, Configuration& config);
    virtual ~AIVIConfigurator() {}

    // from ISceneProvider
    virtual bool configure();

    //from IPlugin
    virtual t_ilm_const_string pluginGetName() const;
    virtual int getIterationCounter();
    virtual PluginApi pluginGetApi() const;
    virtual HealthCondition pluginGetHealth();

    bool vReadEarlyConfig();
    void updateScreenLayoutsDefinition();
    bool createScreenLayoutsDir() const;
    bool isFileExistsInSystem(const ::std::string& name) const;
    ::std::string getScreenLayoutsName() const;
    ::std::string getScreenLayoutsNameForRenault() const;

protected:
    ICommandExecutor& mExecutor;
    Configuration& mConfiguration;

private:
    tU8 tU8TrDisplayOrder[4];
    tU8 tU8TrFlushDesignConfigFile[64];
    tU8 tU8EarlyBrand;
    tU8 tU8EarlyDisplayOrientation;
    tU8 tU8EarlyResolution[32];
    // AIVI-68581: Whitepoint correction
    unsigned int iWPC_ScreenID;
    t_ilm_int iaWPC_Diagnal_matrix[3];
};

#endif /* _CONFIGURATOR_ */
